#include <bits/stdc++.h>
using namespace std;
using int64 = long long;
const int64 INF_L = (int64)9e18;

struct SegmentnoStabloMin {
    int n;
    vector<int64> st;
    SegmentnoStabloMin(int sz=0) { init(sz); }
    void init(int sz) {
        n = 1;
        while (n < sz) n <<= 1;
        st.assign(2*n, INF_L);
    }
    void postavi(int poz, int64 val) {
        int idx = poz + n;
        st[idx] = val;
        for (idx >>= 1; idx; idx >>= 1)
            st[idx] = min(st[2*idx], st[2*idx+1]);
    }
    int64 upit_min(int l, int r) {
        if (l > r) return INF_L;
        l += n; r += n;
        int64 res = INF_L;
        while (l <= r) {
            if (l & 1) res = min(res, st[l++]);
            if (!(r & 1)) res = min(res, st[r--]);
            l >>= 1; r >>= 1;
        }
        return res;
    }
};

struct SegmentnoStabloMax {
    int n;
    vector<int64> st;
    SegmentnoStabloMax(int sz=0) { init(sz); }
    void init(int sz) {
        n = 1;
        while (n < sz) n <<= 1;
        st.assign(2*n, -INF_L);
    }
    void postavi(int poz, int64 val) {
        int idx = poz + n;
        st[idx] = val;
        for (idx >>= 1; idx; idx >>= 1)
            st[idx] = max(st[2*idx], st[2*idx+1]);
    }
    int64 upit_max(int l, int r) {
        if (l > r) return -INF_L;
        l += n; r += n;
        int64 res = -INF_L;
        while (l <= r) {
            if (l & 1) res = max(res, st[l++]);
            if (!(r & 1)) res = max(res, st[r--]);
            l >>= 1; r >>= 1;
        }
        return res;
    }
};

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    if (!(cin >> n)) return 0;
    vector<int64> pozicije(n), visine(n);
    for (int i = 0; i < n; ++i) cin >> pozicije[i];
    for (int i = 0; i < n; ++i) cin >> visine[i];

    vector<int> indeksi(n);
    iota(indeksi.begin(), indeksi.end(), 0);
    sort(indeksi.begin(), indeksi.end(),
         [&](int a, int b){ return pozicije[a] < pozicije[b]; });

    vector<int> mesto_u_sorti(n);
    for (int i = 0; i < n; ++i) mesto_u_sorti[indeksi[i]] = i;

    vector<pair<int64,int>> parovi(n);
    for (int i = 0; i < n; ++i) parovi[i] = {visine[i], i};
    sort(parovi.begin(), parovi.end(), greater<pair<int64,int>>());

    vector<vector<int>> grupe;
    vector<int64> visina_grupe;
    int ptr = 0;
    while (ptr < n) {
        int64 H = parovi[ptr].first;
        vector<int> grupa;
        while (ptr < n && parovi[ptr].first == H) {
            grupa.push_back(parovi[ptr].second);
            ++ptr;
        }
        grupe.push_back(move(grupa));
        visina_grupe.push_back(H);
    }

    SegmentnoStabloMin stMin(n);
    SegmentnoStabloMax stMax(n);

    stMin.init(n);
    stMax.init(n);

    vector<int64> odgovor(n, -1);

    for (size_t gi = 0; gi < grupe.size(); ++gi) {
        int64 H = visina_grupe[gi];
        auto &lista = grupe[gi];

        for (int ori_idx : lista) {
            int pos = mesto_u_sorti[ori_idx];
            int64 x = pozicije[ori_idx];
            int64 h = visine[ori_idx];
            stMin.postavi(pos, x - h);
            stMax.postavi(pos, x + h);
        }

        for (int ori_idx : lista) {
            int pos = mesto_u_sorti[ori_idx];
            int64 x_i = pozicije[ori_idx];
            int64 h_i = visine[ori_idx];

            stMin.postavi(pos, INF_L);
            stMax.postavi(pos, -INF_L);

            int64 globalMin = stMin.upit_min(0, n-1);
            int64 globalMax = stMax.upit_max(0, n-1);

            if (globalMin == INF_L && globalMax == -INF_L) {
                odgovor[ori_idx] = -1;
            } else {
                int64 min_desno = stMin.upit_min(pos, n-1);
                int64 trosak_desno = INF_L;
                if (min_desno != INF_L) {
                    trosak_desno = (H + min_desno) - x_i;
                }

                int64 max_levo = stMax.upit_max(0, pos);
                int64 trosak_levo = INF_L;
                if (max_levo != -INF_L) {
                    trosak_levo = H + x_i - max_levo;
                }

                int64 kandidat = INF_L;
                if (trosak_desno != INF_L) kandidat = min(kandidat, trosak_desno);
                if (trosak_levo != INF_L) kandidat = min(kandidat, trosak_levo);

                if (kandidat == INF_L) odgovor[ori_idx] = -1;
                else {
                    if (kandidat < 0) kandidat = 0;
                    odgovor[ori_idx] = kandidat;
                }
            }

            int64 x = pozicije[ori_idx];
            int64 h = visine[ori_idx];
            stMin.postavi(pos, x - h);
            stMax.postavi(pos, x + h);
        }
    }

    for (int i = 0; i < n; ++i) {
        if (odgovor[i] < 0) cout << -1 << '\n';
        else cout << odgovor[i] << '\n';
    }

    return 0;
}